/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class OxygenTankOverlay {
    public static final ResourceLocation OXYGEN_TANK = ResourceLocationUtils.texture("overlay/oxygen_tank");
    public static final ResourceLocation OXYGEN_TANK_FULL = ResourceLocationUtils.texture("overlay/oxygen_tank_full");

    public static void render(GuiGraphics graphics, float partialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (Utils.isLivingInJetSuit((LivingEntity)player)) {
            ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
            Minecraft mc = Minecraft.getInstance();
            if (chest.getItem() instanceof AbstractSpaceArmor.Chestplate) {
                UniversalFluidStorage chestplateStorage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(chest);
                if (chestplateStorage == null) {
                    return;
                }
                long oxygen = chestplateStorage.getFluidInTank(0).getAmount();
                long maxOxygen = chestplateStorage.getTankCapacity(0);
                int x = 5;
                int y = 5;
                int textureWidth = 62;
                int textureHeight = 52;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ScreenHelper.drawTexture(x, y, textureWidth, textureHeight, OXYGEN_TANK, false);
                ScreenHelper.drawVertical(graphics, x, y, textureWidth, textureHeight, oxygen, maxOxygen, OXYGEN_TANK_FULL, false);
                Font font = mc.font;
                MutableComponent text = Component.translatable((String)"general.stellaris.oxygen").append(": ").withStyle(ChatFormatting.BLUE).append("\u00a77" + oxygen / (maxOxygen / 100L) + "%");
                graphics.drawString(font, (Component)text, x + (textureWidth - font.width((FormattedText)text)) / 2, y + textureHeight + 3, 0xFFFFFF);
            }
        }
    }
}

